#include "string.h"
#include "AudioStack/clStack.h"

#include "AudioStack/SMT/clSrcState.h"
#include "AudioStack/clAudioSourceController.h"
#include "AudioStack/clAudioSMEngine.h"

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clStack.cpp.trc.h"
#endif

namespace AudioStack
{

clStack::clStack()
{
   OSAL_pvMemorySet(m_sources, 0, sizeof(m_sources));
   m_SP = 0;
   m_enumBgSource = NULL;
}

clStack::~clStack()
{
  OSAL_pvMemorySet(m_sources, 0, sizeof(m_sources));
  m_SP = 0;
  m_enumBgSource = NULL;
}

void clStack::vResetStack()
{
   OSAL_pvMemorySet(m_sources, 0, sizeof(m_sources));
   m_SP = 0;
   m_enumBgSource = NULL;
}

clAudioSource* clStack::GetTopSource(AudioSources::enAudioSources srcClass) const
{

   for(int SP=m_SP; SP>0; SP--) {
      if(m_sources[SP-1]->sGetId().enSourceClass ==  srcClass)
      {
         return m_sources[SP-1];
      }

   }
   return NULL;
}

void clStack::DoPushActions(clAudioSource &src)
{
  int i;
  AudioStack::clStackRules::actions_t action;
  /* loop over possible actions */
  for(i=0; (action=src.getPushAction(i)) != clStackRules::/*actions_t::*/end; i++) {

    switch(action & clStackRules::/*actions_t::*/mask) {
    case clStackRules::/*actions_t::*/action_abort:
         ETG_TRACE_USR4(("Found Abort action for: %d",
                               ETG_CENUM(AudioSources::enAudioSources, static_cast<AudioSources::enAudioSources>(action & clStackRules::/*actions_t::*/idxMask))));
         RemoveInternal_SourceClass(
               static_cast<AudioSources::enAudioSources>(action & clStackRules::/*actions_t::*/idxMask), src.sGetId());
      break;
    }
  }
}

void clStack::DoPopActions(clAudioSource &src)
{
  int i;
  clStackRules::actions_t action;

  /* loop over possible actions */
  for(i=0; (action=src.getPopAction(i)) != clStackRules::/*actions_t::*/end; i++) {

    switch(action & clStackRules::/*actions_t::*/mask) {
    case clStackRules::/*actions_t::*/action_abort:
       RemoveInternal_SourceClass(
             static_cast<AudioSources::enAudioSources>(action & clStackRules::/*actions_t::*/idxMask), src.sGetId());
      break;
    }
  }
}

bool clStack::AddSource(clAudioSource &src)
{
  clStackRules::allow_t allow;

  /* check stack pointer */
  if (m_SP == (MAX_AUDIO_SOURCES-1)) return false;

  //Check if there is Entertainment source in stack
  // AND given source is Entertainment
  if((NULL == GetCurrentBgSource())&&(src.getType() == clStackRules::typeBg))
  {
   ETG_TRACE_USR1(("AddSource: ********Before********"));
   trace();
     //move all one position up
     int SP;

     //for(SP=0; SP<m_SP; ++SP)
     //{
     //  m_sources[SP+1] = m_sources[SP];
     //}
     //bool triggerPause=false

     for(SP=m_SP;SP>0;SP--)
     {
       //if m_sources[SP].getTzpe != Mix then set flag triggerPause = true
       m_sources[SP] = m_sources[SP-1];
     }

     //insert at bottom
     m_sources[SP] = &src;
     //stack is now one element longer
     m_SP++;
     //that's it
     //if(triggerPause)
     //src.vPause
       //else
     //src.vON

   ETG_TRACE_USR1(("AddSource: ********After********"));
   trace();

     return true;
  }
  /* add first element on stack */
  if (m_SP == 0) {
    m_sources[m_SP++] = &src;
    return true;
  }
  /* add new element, ask the stack for the position */
  int SP;

  /* check if source still on stack */
  for(SP=m_SP; SP>0; SP--) {
     if(m_sources[SP-1]->sGetId() == (&src)->sGetId())
     {
        // bg source, which is still on stack has to be shifted to top of bg sources
        if ((&src)->getType() == clStackRules::typeBg)
        {
           if (SP<m_SP && m_sources[SP]->getType() == clStackRules::typeBg)
           {
              // there is another bg-source above of this, so put this one up
              m_sources[SP-1] = m_sources[SP];
              m_sources[SP] = &src;
           }
        }
        // no action for fg source
        else
        {}
        return true;
     }
  }

  /* add to stack, ask element on top of stack */
  for(SP=m_SP; SP>0; SP--) {

     allow = m_sources[SP-1]->allowOnTop(&src);

     switch(allow) {
        case clStackRules::/*allow_t::*/allowed:

           /* insert the new source above the current one */
           int SP2;
           for(SP2=m_SP; SP2>SP; SP2--) {
              m_sources[SP2] = m_sources[SP2-1];
           }
           m_sources[SP] = &src;

           /* stack is now one element longer */
           m_SP++;

           /* apply actions to the stack */
           DoPushActions(src);

           /* successfull */
           return true;

        case clStackRules::/*allow_t::*/kicked:
        {
           ETG_TRACE_USR1(("KICK RULE: SourceClass %d will prevent insert of SourceClass %d"
                 ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(m_sources[SP-1]->sGetId().enSourceClass))
                 ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(src.sGetId().enSourceClass))));
           return false;
        }

        default:
           break;
     }
  }

  /* source not pushed */
  return false;

}

clAudioSource*  clStack::AllowSource(clAudioSource &src)
{
   clStackRules::allow_t allow;

   /* check stack pointer */
   if (m_SP == (MAX_AUDIO_SOURCES-1)) return NULL;

   /* add first element on stack */
   if (m_SP == 0) {
      m_sources[m_SP++] = &src;
      return &src;

      /* add new element, ask the steck for the position */
   } else {

      int SP;

      /* check if source still on stack */
      for(SP=m_SP; SP>0; SP--) {
         if(m_sources[SP-1]->sGetId() == (&src)->sGetId())
         {
               return &src;
            }
        }

        //VVD
        if((NULL == GetCurrentBgSource())&&(src.getType() == clStackRules::typeBg))
        {
          ETG_TRACE_USR1(("AllowSource: there is no BG source on stack and new src is BG, hence Allow...."));
          return &src;
        }

    /* add to stack, ask element on top of stack */
    for(SP=m_SP; SP>0; SP--) {

      allow = m_sources[SP-1]->allowOnTop(&src);

      switch(allow) {
      case clStackRules::/*allow_t::*/allowed:

        /* successfull */
            return m_sources[SP-1];

      case clStackRules::/*allow_t::*/kicked:
            {
           return NULL;
            }
      default:
         break;
      }
    }

    /* unknown */
      return NULL;
   }
}

bool clStack::RemoveInternal_SourceClass(AudioSources::enAudioSources rmSrcClass, SourceID nextSrcID)
{
   ETG_TRACE_USR1(("RemoveInternal_SourceClass: Force Off for SourceClass: %d"
            ,ETG_CENUM(AudioSources::enAudioSources,rmSrcClass)));
   clAudioSource* pRmSrc = GetTopSource(rmSrcClass);
   while(pRmSrc != NULL)
   {
      ETG_TRACE_USR1(("RemoveInternal_SourceClass: Check SourceClass: %d subID %#x(%d)"
         ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(pRmSrc->sGetId().enSourceClass))
         , (tU16)pRmSrc->sGetId().u16SubSource
         , (tU16)pRmSrc->sGetId().u16SubSource));
      //RemoveSrcInternal may remove Source completely synchronously
      //so we need to remeber which source was below
      clAudioSource* pUnderlayingSrc = GetUnderlayingSource(*pRmSrc);
      if(pRmSrc->sGetId().enSourceClass == rmSrcClass)
      {
         return RemoveInternal_Source(pRmSrc->sGetId(),nextSrcID);
      }
      pRmSrc = pUnderlayingSrc;
   }
   return false;
}

bool clStack::RemoveInternal_Source(SourceID rmSrcID, SourceID nextSrcID)
/*
 internal remove function. calls OFF of AudioSource Controller ind indirect the public remove function
 */
{
  int SP;
  clAudioSource *src;

  /* add to stack, ask element on top of stack */
  for(SP=m_SP-1; SP>=0; SP--) {
    if (m_sources[SP]->sGetId() == rmSrcID) {

      /* remember this element */
      src = m_sources[SP];

      /* switch off source */
      //OFF(src, u8NextSrcId);
      ETG_TRACE_USR1(("RemoveSourceInternal: Force Off for SourceClass: %d subID %#x(%d)"
         ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(src->sGetId().enSourceClass))
         , (tU16)src->sGetId().u16SubSource
         , (tU16)src->sGetId().u16SubSource));

      clAudioSMEngine::Source_Off(src->sGetId(), static_cast<tU32>(BITMASK_FORCE_OFF));
      /* do pop actions */
      DoPopActions(*src);

      // direct and synchronous removal or src, if already in state off
      // otherwise removal will be done on: Off_Done()
      if (src->bIsOff())
      {
        RemoveSource(*src);
      }
      /* element popped */
      return true;
    }
  }
   ETG_TRACE_USR4(("RemoveSourceInternal: Not active: SourceClass: %d subID %#x(%d)"
         ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(rmSrcID.enSourceClass))
         , (tU16)rmSrcID.u16SubSource
         , (tU16)rmSrcID.u16SubSource));
  /* source not popped */
  return false;
}

bool clStack::RemoveSource(clAudioSource &src)
{
   int SP;

   /* remove from stack, ask element on top of stack */
   for(SP=m_SP-1; SP>=0; SP--) {
      if (m_sources[SP] == &src) {
         for(; SP<m_SP-1; SP++) {   //lint !e445 PQM_authorized_246. Reason: Same loop variable used intentionally, reviewed and not critical
            if (SP>=0){ // for LINT
               m_sources[SP] = m_sources[SP+1];
            }
         }
         m_SP--;

         /* apply pop actions to the stack */
         DoPopActions(src);

         /* element popped */
         return true;
      }
   }

   /* source not popped */
   return false;
}

clAudioSource * clStack::GetUnderlayingSource(clAudioSource &src) const
{
  int SP;

  /* ... */
  for(SP=m_SP-1; SP>=0; SP--) {
    if (m_sources[SP] == &src) {
      if (SP == 0) return NULL;
      else return m_sources[SP-1];
    }
  }

  return NULL;
}


clAudioSource * clStack::GetTopSource() const
{
  if (m_SP == 0) return NULL;
  else return m_sources[m_SP-1];
}

void clStack::trace() const
{
  int SP;

  ETG_TRACE_USR1(("AST:  --------TOP--------"));
  for(SP=m_SP-1; SP>=0; SP--)
  {
     ETG_TRACE_USR1(("AST:  %15s : %15s (SrcClass %d(%#x), SubID %d(%#x))"
        ,m_sources[SP]->pacGetName()
        ,m_sources[SP]->pclGetState()->m_pacName
        ,m_sources[SP]->sGetId().enSourceClass
        ,m_sources[SP]->sGetId().enSourceClass
        ,m_sources[SP]->sGetId().u16SubSource
        ,m_sources[SP]->sGetId().u16SubSource));
  }
  ETG_TRACE_USR1(("AST:  ------BOTTOM-------"));
}

bool clStack::OFF(clAudioSource *source, SourceID srcID)
{
  if(source != NULL)
  {
    source->vOff(srcID);
    return TRUE;
  }
  return FALSE;
}

clAudioSource *clStack::GetCurrentBgSource() const
{
  int SP;

  // add to stack, ask element on top of stack
  for(SP=m_SP-1; SP>=0; SP--) {
    if (m_sources[SP]->getType() == clStackRules::typeBg) {
      //m_enumBgSource = m_sources[SP];
      return m_sources[SP];
    }
  }
  return NULL;
}

}//namespace

/* EOF */

